-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.msgIron:LinkToTarget("ironQuestMsg")
    
    if not self.loaded then
      self.active = true
      self.timer = 4
    end
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckForPlayer(self)
    end
  end  
end

function CheckForPlayer(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 4000, '*')
  
  if p0units > 1 then
    
    self.active = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("msgIron")
end
